# pip install accessible-output2 requests tqdm pyzipper
# Downloader Class: https://github.com/tunmi13productions/Class-and-Script-pack/blob/main/Python/downloader/downloader.py
# To build properly, you may want to disable TQDM in the downloader class.

import os
import subprocess
import pyzipper
import sys
import shutil
import downloader as dl
from accessible_output2 import outputs

output = outputs.auto.Auto()

# Constants
ZIP_URL = "https://example.com/NVDA.zip"
ZIP_FILENAME = "NVDA.zip"
EXTRACT_DIR = "."
TEMP_NVDA_DIR = os.path.join(EXTRACT_DIR, "NVDA")
PASSWORD = b"" # Fill in this string with the actual password to your NVDA zip file.

# Step 1: Download the encrypted ZIP
output.output("Downloading NVDA...")
dl.dl(ZIP_URL, ZIP_FILENAME)
output.output("Download complete.")

# Step 2: Extract with AES-256 password
output.output("Extracting the ZIP file...")
with pyzipper.AESZipFile(ZIP_FILENAME) as zf:
    zf.pwd = PASSWORD
    zf.extractall(EXTRACT_DIR)
output.output("Extraction complete.")
os.remove(ZIP_FILENAME)

# Step 3: Run NVDA installer
nvda_exe_path = os.path.join(TEMP_NVDA_DIR, "nvda.exe")
if os.path.isfile(nvda_exe_path):
    output.output("Running NVDA installer...")
    subprocess.run([nvda_exe_path, "--install", "--copy-portable-config"], check=True)
    output.output("NVDA installed.")

    # Restart Windows Explorer
    output.output("Restarting Windows Explorer...")
    subprocess.run(["taskkill", "/f", "/im", "explorer.exe"], stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL)
    subprocess.run(["start", "explorer"], shell=True)
    
    # Delete NVDA directory
    output.output("Cleaning up...")
    shutil.rmtree(TEMP_NVDA_DIR, ignore_errors=True)

    output.output("Cleanup complete. Exiting.")
else:
    output.output("nvda.exe not found. Aborting.")
    sys.exit(1)

sys.exit(0)
